;;; Cadalyst April 2003 AutoLISP Solutions
;;; import-3d-poly.lsp imports x,y,z coordinates
;;; from Excel spreadsheet into AutoCAD.
;;; Program (c) Tony Hotchkiss, 2003
;;;
(defun err (s)
  (if (= s "Function cancelled")
    (princ "IMPORT-3D-POLY - cancelled: ")
    (progn (princ "IMPORT-3D-POLY - Error: ")
	   (princ s)
	   (terpri)
    ) ;_ progn
  ) ; if
  (resetting)
  (princ "SYSTEM VARIABLES have been reset\n")
  (princ)
) ; err
(defun setv (systvar newval)
  (setq x (read (strcat systvar "1")))
  (set x (getvar systvar))
  (setvar systvar newval)
) ; setv 
(defun setting ()
  (setq oerr *error*)
  (setq *error* err)
  (setv "CMDECHO" 0)
  (setv "BLIPMODE" 0)
) ; end of setting 
(defun rsetv (systvar)
  (setq x (read (strcat systvar "1")))
  (setvar systvar (eval x))
) ; restv
(defun resetting ()
  (rsetv "CMDECHO")
  (rsetv "BLIPMODE")
  (setq *error* oerr)
) ; end of resetting 

(defun poly3D ()
  (setq	ptlist1	(get-ptlist))
  (make-3dpolyline ptlist1)
) ;_ poly3D

(defun get-ptlist ()
  (setq	fn    (getfiled "3D points file" "" "txt" 8)
	f     (open fn "r")
	str   (read-line f)
	plist nil
  ) ;_ end of setq
  (while (/= str EOF)
    (setq str (read-line f))
    (if	str
      (progn
	(setq pt (get-pt str))
	(setq plist (append plist (list pt)))
      ) ;_ end of progn
    ) ;_ end of if 
  ) ;_ end of while
  (setq f (close f))
  plist
) ;_ get-ptlist

(defun get-pt (str1)
  (setq	comma (chr 44)
	str2  ""
	count 1
	i     0
  ) ;_ end of setq
  (repeat 2
    (repeat (strlen str1)
      (setq char (substr str1 (setq i (1+ i)) 1))
      (if (/= char comma)
	(setq str2 (strcat str2 char))
	(progn
	  (if (= count 1)
	    (progn
	      (setq x (atof str2))
	      (setq str1 (substr str1 (1+ i)))
	      (setq i 0)
	      (setq count 2)
	      (setq str2 "")
	    ) ;_ end of progn
	    (progn
	      (setq y (atof str2))
	      (setq str1 (substr str1 (1+ i)))
	      (setq z (atof str1))
	    ) ;_ end of progn
	  ) ;_ end of if
	) ;_ end of progn
      ) ;_ end of if
    ) ;_ end of repeat
  ) ;_ end of repeat
  (setq pt (list x y z))
) ;_ end of get-pt

(defun make-3dpolyline (ptlist)
  (entmake (list '(0 . "POLYLINE")
		 '(100 . "AcDbEntity")
		 '(100 . "AcDb3dPolyline")
		 '(70 . 8)
	   ) ;_ list
  ) ;_ entmake
  (repeat (length ptlist)
    (setq pt	 (car ptlist)
	  ptlist (cdr ptlist)
    ) ;_ setq
    (entmake (list '(0 . "VERTEX")
		   '(100 . "AcDb3dPolylineVertex")
		   (cons 10 pt)
		   '(70 . 32)
	     ) ;_ list
    ) ;_ entmake
  ) ;_ repeat
  (entmake '((0 . "SEQEND")))
) ;_ make-3dpolyline

(defun pl3 ()
  (setting)
  (poly3D)
  (resetting)
  (princ)
) ;_ c:pl3

(prompt "ѡıļ,һΪx,y,zһΪʽĵ")